<?php
require_once __DIR__ . '/../config/db.php';

function logMessageAttempt($messageType, $recipient, $messageContent, $status, $errorMessage = '', $details = '') {
    global $pdo;
    try {
        $stmt = $pdo->prepare("
            INSERT INTO system_logs (
                module, 
                action_type, 
                action, 
                details, 
                message_type,
                message_status,
                recipient,
                message_content,
                error_message,
                user_id, 
                created_at
            ) VALUES (
                'messaging',
                'message_sent',
                ?,
                ?,
                ?,
                ?,
                ?,
                ?,
                ?,
                ?,
                NOW()
            )
        ");
        
        $action = ucfirst($messageType) . " sent to: " . $recipient;
        $details = json_encode([
            'message_type' => $messageType,
            'recipient' => $recipient,
            'status' => $status,
            'details' => $details,
            'timestamp' => date('Y-m-d H:i:s')
        ]);
        $user_id = $_SESSION['user_id'] ?? null;
        
        $stmt->execute([
            $action, 
            $details, 
            $messageType, 
            $status, 
            $recipient, 
            $messageContent, 
            $errorMessage, 
            $user_id
        ]);
    } catch (Exception $e) {
        error_log("Failed to log message attempt: " . $e->getMessage());
    }
} 